<?php

declare (strict_types=1);
namespace Rector\PostRector\Guard;

use PhpParser\Node\Stmt;
use PhpParser\Node\Stmt\InlineHTML;
use PhpParser\Node\Stmt\Namespace_;
use Rector\PhpParser\Node\BetterNodeFinder;
use Rector\PhpParser\Node\FileNode;
final class AddUseStatementGuard
{
    /**
     * @readonly
     */
    private BetterNodeFinder $betterNodeFinder;
    /**
     * @var array<string, bool>
     */
    private array $shouldTraverseOnFiles = [];
    public function __construct(BetterNodeFinder $betterNodeFinder)
    {
        $this->betterNodeFinder = $betterNodeFinder;
    }
    /**
     * @param Stmt[] $stmts
     */
    public function shouldTraverse(array $stmts, string $filePath): bool
    {
        if (isset($this->shouldTraverseOnFiles[$filePath])) {
            return $this->shouldTraverseOnFiles[$filePath];
        }
        $totalNamespaces = 0;
        // just loop the first level stmts to locate namespace to improve performance
        // as namespace is always on first level
        if (isset($stmts[0]) && $stmts[0] instanceof FileNode) {
            $stmts = $stmts[0]->stmts;
        }
        foreach ($stmts as $stmt) {
            if ($stmt instanceof Namespace_) {
                ++$totalNamespaces;
            }
            // skip if 2 namespaces are present
            if ($totalNamespaces === 2) {
                return $this->shouldTraverseOnFiles[$filePath] = \false;
            }
        }
        return $this->shouldTraverseOnFiles[$filePath] = !$this->betterNodeFinder->hasInstancesOf($stmts, [InlineHTML::class]);
    }
}
