<?php

return [
    'name' => '位置',
    'all_states' => '所有州',
    'abbreviation' => '缩写',
    'abbreviation_placeholder' => '例如：CA',
    'enums' => [
        'import_type' => [
            'country' => '国家',
            'state' => '州',
            'city' => '城市',
        ],
    ],
    'export' => [
        'total' => '总位置',
        'total_countries' => '总国家数',
        'total_states' => '总州',
        'total_cities' => '总城市数',
        'description' => '导出您的位置信息，如国家、州和城市。',
        'import_type' => '导入类型',
        'all_types' => '所有类型',
        'all_status' => '所有状态',
        'use_chunked_export' => '使用分块导出',
        'use_chunked_export_helper' => '对大型导出文件分块处理数据。建议用于超过1,000条记录的数据集。',
        'optimize_memory' => '优化内存使用',
        'optimize_memory_helper' => '通过分步处理减少内存使用。建议用于服务器内存有限的情况。',
        'use_streaming' => '使用流式传输',
        'use_streaming_helper' => '直接将数据写入文件而不是存储在内存中。最适合非常大的导出。',
        'streaming_enabled_title' => '已启用流式传输',
        'streaming_enabled_message' => '数据将直接流式传输到文件以实现最佳效率。',
        'chunk_size' => '块大小',
        'chunk_size_helper' => '一次处理的行数。较小的值使用较少的内存，但可能会减慢导出速度。',
        'recommended_range' => '推荐范围',
        'optimal_range' => '最佳范围',
        'too_small_slow' => '太小的值可能会减慢处理速度',
        'too_large_timeouts' => '太大的值可能会导致超时',
        'range_large_export' => '大型导出为500-2000',
        'range_medium_export' => '中型导出为200-1000',
        'range_small_export' => '小型导出为100-500',
        'large_dataset_title' => '检测到大型数据集',
        'large_dataset_message' => '由于您的数据规模，导出可能需要一些时间。这是正常过程并确保稳定性。',
        'large_dataset_warning_title' => '大型导出',
        'large_dataset_specific_message' => '您正在导出超过:count条记录。此操作可能需要几分钟。',
        'format_label' => '格式',
        'csv_recommended' => 'CSV（推荐用于大型数据集）',
        'chunk_label' => '块大小',
        'chunk_recommended' => ':size行（推荐）',
        'time_label' => '预计时间',
        'time_estimate' => '约:minutes分钟',
        'pro_tip' => '专业提示',
        'pro_tip_message' => 'CSV格式为大型导出提供更好的性能和兼容性。您可以将其导入Excel或Google Sheets。',
        'medium_dataset_detected' => '检测到中型数据集',
        'medium_dataset_message' => '此导出可能需要几秒钟。为了获得最佳性能，我们建议使用分块导出设置。',
        'excel_disabled_warning' => 'Excel导出不适用于超过:count条记录的数据集。请使用CSV格式。',
    ],
    'import' => [
        'description' => '轻松从可用数据中导入位置数据或通过上传CSV/Excel文件。',
        'rules' => [
            'name' => '地点名称是必填项，且不得超过120个字符。',
            'slug' => '位置的别名（如果提供）不得超过120个字符。',
            'import_type' => '导入类型是必需的，应该是预定义值之一。',
            'order' => '位置的顺序（如果提供）应为0到127之间的正整数。',
            'abbreviation' => '地点的缩写（如果提供）不得超过10个字符。',
            'status' => '位置状态是必需的，应该是预定义值之一。',
            'country' => '国家字段是必填项，如果导入类型是州或城市。',
            'state' => '州字段是必填项，如果导入类型是城市。',
            'nationality' => '该地点的国籍（如果提供）不得超过120个字符。',
        ],
    ],
];
