<?php

namespace Database\Seeders\Themes\Home5;

use Botble\Page\Models\Page;

class PageSeeder extends \Database\Seeders\Themes\Main\PageSeeder
{
    public function run(): void
    {
        parent::run();

        $homepage = Page::query()->where('name', 'Homepage')->firstOrFail();

        $homepage->update([
            'content' => $this->generateShortcodeContent([
                [
                    'name' => 'simple-slider',
                    'attributes' => [
                        'key' => 'home-slider',
                        'title_font_size' => 64,
                        'is_autoplay' => 'yes',
                        'autoplay_speed' => 5000,
                        'is_loop' => 'yes',
                    ],
                ],
                [
                    'name' => 'about-us-information-tabs',
                    'attributes' => [
                        'title' => 'High <b>Performance</b> <br> <b>Services For</b> All Industries.',
                        'image' => $this->filePath('general/about-us-information-tabs-1.png'),
                        'data_counter_title_1' => 'Projects Completed',
                        'data_counter_1' => '23',
                        'data_counter_unit_1' => 'k',
                        'data_counter_title_2' => 'Happy Clients',
                        'data_counter_2' => '98',
                        'data_counter_unit_2' => 'k',
                        'features' => 'Best For IT Consulting | Tailored Solutions | Save Money & Time | Expert Team',
                        'quantity' => '3',
                        'title_1' => 'Our History',
                        'description_1' => 'Founded in 1998,  started as a small consulting firm with a big vision: to provide unparalleled strategic and operational expertise to businesses of all sizes.',
                        'content_1' => 'Over the years, we have expanded our services and grown our team of skilled professionals, building a reputation for delivering results-driven solutions. From our humble beginnings to becoming a trusted partner for clients across diverse industries',
                        'image_1' => $this->filePath('general/about-us-information-tabs-2.png'),
                        'title_2' => 'Our Mission',
                        'description_2' => 'Deliver Results-Driven Solutions: To provide actionable and impactful strategies that drive measurable success for our clients.',
                        'content_2' => 'Foster Innovation: To encourage creativity and forward-thinking in all our projects, ensuring our clients stay ahead of the curve. Build Lasting Partnerships: To cultivate strong, collaborative relationships with our clients, based on trust, transparency, and mutual respect. Enhance Operational Efficiency: To streamline processes and optimize operations, helping businesses achieve their goals more effectively.',
                        'image_2' => $this->filePath('general/about-us-information-tabs-3.png'),
                        'title_3' => 'Our Version',
                        'description_3' => 'At Infinia, our vision is to empower businesses to reach their full potential through innovative strategies and expert operational support.',
                        'content_3' => 'We strive to be the leading consulting firm known for our unwavering commitment to excellence, integrity, and client success. By continuously evolving and adapting to the ever-changing business landscape, we aim to provide solutions that not only meet the needs of today but also anticipate the challenges of tomorrow.',
                        'image_3' => $this->filePath('general/about-us-information-tabs-4.png'),
                        'author_name' => 'Kensei',
                        'author_title' => 'SEO',
                        'author_signature' => $this->filePath('general/author-signature.png'),
                        'author_avatar' => $this->filePath('general/author-avatar.png'),
                        'bottom_description' => 'No Card Required. Cancel Anytime.',
                        'primary_action_label' => 'Get 15 Days Free Trial',
                        'primary_action_url' => '/pricing',
                        'primary_action_icon' => 'ti ti-arrow-narrow-right',
                    ],
                ],
                [
                    'name' => 'services',
                    'attributes' => [
                        'style' => '2',
                        'service_ids' => '1,3,4,5',
                        'background_color' => '#a38cff',
                        'background_image' => $this->filePath('backgrounds/team.png'),
                    ],
                ],
                [
                    'name' => 'feature-tabs',
                    'attributes' => [
                        'title' => 'Building <b>enduring value</b> <br> through <b>bold</b> strategies',
                        'subtitle' => 'WHAT WE OFFERS',
                        'quantity' => '6',
                        'tab_name_1' => 'Financial Consultancy',
                        'title_1' => 'Pick Your Premium',
                        'description_1' => 'We strive to build long-lasting partnerships with our clients, understanding their unique challenges and opportunities, and providing tailored strategies that lead to measurable success.',
                        'image_1' => $this->filePath('general/feature-tabs-1.png'),
                        'feature_item_title_1_1' => 'Research planning',
                        'feature_item_description_1_1' => 'Separating your work from your home life can improve work-life balance.',
                        'feature_item_icon_image_1_1' => $this->filePath('icons/icon-14.png'),
                        'feature_item_title_2_1' => 'Investment',
                        'feature_item_description_2_1' => 'A business consultant provides expert advice and guidance to businesses.',
                        'feature_item_icon_image_2_1' => $this->filePath('icons/icon-15.png'),
                        'tab_name_2' => 'Business Consultancy',
                        'title_2' => 'Build LastingPartnerships',
                        'description_2' => 'We strive to build long-lasting partnerships with our clients, understanding their unique challenges and opportunities, and providing tailored strategies that lead to measurable success.',
                        'image_2' => $this->filePath('general/feature-tabs-2.png'),
                        'feature_item_title_1_2' => 'Research planning',
                        'feature_item_description_1_2' => 'Separating your work from your home life can improve work-life balance.',
                        'feature_item_icon_image_1_2' => $this->filePath('icons/icon-14.png'),
                        'feature_item_title_2_2' => 'Investment',
                        'feature_item_description_2_2' => 'A business consultant provides expert advice and guidance to businesses.',
                        'feature_item_icon_image_2_2' => $this->filePath('icons/icon-2.png'),
                        'tab_name_3' => 'Solicitory Consultancy',
                        'title_3' => 'Enhance Operational',
                        'description_3' => 'We strive to build long-lasting partnerships with our clients, understanding their unique challenges and opportunities, and providing tailored strategies that lead to measurable success.',
                        'image_3' => $this->filePath('general/feature-tabs-3.png'),
                        'feature_item_title_1_3' => 'Research planning',
                        'feature_item_description_1_3' => 'Separating your work from your home life can improve work-life balance.',
                        'feature_item_icon_image_1_3' => $this->filePath('icons/icon-3.png'),
                        'feature_item_title_2_3' => 'Investment',
                        'feature_item_description_2_3' => 'A business consultant provides expert advice and guidance to businesses.',
                        'feature_item_icon_image_2_3' => $this->filePath('icons/icon-17.png'),
                        'tab_name_4' => 'HR Consultancy',
                        'title_4' => 'Sustainable Growth',
                        'description_4' => 'We strive to build long-lasting partnerships with our clients, understanding their unique challenges and opportunities, and providing tailored strategies that lead to measurable success.',
                        'image_4' => $this->filePath('general/feature-tabs-4.png'),
                        'feature_item_title_1_4' => 'Research planning',
                        'feature_item_description_1_4' => 'Separating your work from your home life can improve work-life balance.',
                        'feature_item_icon_image_1_4' => $this->filePath('icons/icon-12.png'),
                        'feature_item_title_2_4' => 'Investment',
                        'feature_item_description_2_4' => 'A business consultant provides expert advice and guidance to businesses.',
                        'feature_item_icon_image_2_4' => $this->filePath('icons/icon-18.png'),
                        'tab_name_5' => 'Strategy Consultancy',
                        'title_5' => 'Continuous Evolution',
                        'description_5' => 'We strive to build long-lasting partnerships with our clients, understanding their unique challenges and opportunities, and providing tailored strategies that lead to measurable success.',
                        'image_5' => $this->filePath('general/feature-tabs-5.png'),
                        'feature_item_title_1_5' => 'Research planning',
                        'feature_item_description_1_5' => 'Separating your work from your home life can improve work-life balance.',
                        'feature_item_icon_image_1_5' => $this->filePath('icons/icon-15.png'),
                        'feature_item_title_2_5' => 'Investment',
                        'feature_item_description_2_5' => 'A business consultant provides expert advice and guidance to businesses.',
                        'feature_item_icon_image_2_5' => $this->filePath('icons/icon-14.png'),
                        'tab_name_6' => 'Start Ups',
                        'title_6' => 'Empower Businesses',
                        'description_6' => 'We strive to build long-lasting partnerships with our clients, understanding their unique challenges and opportunities, and providing tailored strategies that lead to measurable success.',
                        'image_6' => $this->filePath('general/feature-tabs-6.png'),
                        'feature_item_title_1_6' => 'Research planning',
                        'feature_item_description_1_6' => 'Separating your work from your home life can improve work-life balance.',
                        'feature_item_icon_image_1_6' => $this->filePath('icons/icon-15.png'),
                        'feature_item_title_2_6' => 'Investment',
                        'feature_item_description_2_6' => 'A business consultant provides expert advice and guidance to businesses.',
                        'feature_item_icon_image_2_6' => $this->filePath('icons/icon-12.png'),
                        'background_image' => $this->filePath('backgrounds/team.png'),
                        'primary_action_label' => 'Get a Free Quote',
                        'primary_action_url' => '/contact',
                        'primary_action_icon' => 'ti ti-arrow-right',
                        'secondary_action_label' => 'Our Help Center',
                        'secondary_action_url' => '/contact',
                        'secondary_action_icon' => 'ti ti-phone-call',
                    ],
                ],
                [
                    'name' => 'teams',
                    'attributes' => [
                        'style' => '4',
                        'title' => 'Meet Our Team',
                        'subtitle' => 'OUR TEAM MEMBERS',
                        'description' => 'Meet the talented and passionate team members who drive our company forward every day.',
                        'team_ids' => '1,2,3,4,5,6,7',
                    ],
                ],
                [
                    'name' => 'partners',
                    'attributes' => [
                        'style' => 2,
                        'title' => 'Loved By Developers \n Trusted By Enterprises',
                        'description' => 'We helped these brands turn online assessments into success stories.',
                        'primary_action_label' => 'View Our Partners',
                        'primary_action_url' => '/contact',
                        'primary_action_icon' => 'ti ti-arrow-right',
                        'quantity' => 12,
                        ...collect(['Framer', 'Reddit', 'Netflix', 'Microsoft', 'Discover', 'Lemon Squeezy', 'Paypal', 'Mailchimp', 'Slack', 'Instagram', 'Spotify', 'Medium'])
                            ->mapWithKeys(function ($name, $index) {
                                $index++;

                                $imageName = $index > 8 ? rand(1, 8) : $index;

                                return [
                                    "name_$index" => $name,
                                    "image_$index" => $this->filePath("partners/$imageName.png"),
                                ];
                            })
                            ->all(),
                    ],
                ],
                [
                    'name' => 'projects',
                    'attributes' => [
                        'style' => '2',
                        'title' => 'Recent work',
                        'subtitle' => 'Our feared projects',
                        'description' => '⚡Don\'t miss any contact. Stay connected.',
                        'project_ids' => '1,3,4,6',
                        'limit' => '4',
                    ],
                ],
                [
                    'name' => 'features',
                    'attributes' => [
                        'style' => '8',
                        'title' => 'Doing the successful thing, at <br>  the right time.',
                        'subtitle' => 'Recent work',
                        'description' => 'We strive to build long-lasting partnerships with our clients, understanding their unique challenges and opportunities, and providing tailored strategies that lead to measurable success.',
                        'image' => $this->filePath('general/features-8.png'),
                        'floating_card_title' => 'Years of Experience',
                        'floating_card_data_count' => '25',
                        'floating_card_data_count_unit' => '+',
                        'quantity' => '2',
                        'title_1' => 'Research planning',
                        'description_1' => 'Separating your work from your home life can improve work-life balance.',
                        'icon_image_1' => $this->filePath('icons/icon-14.png'),
                        'title_2' => 'Investment',
                        'description_2' => 'A business consultant provides expert advice and guidance to businesses.',
                        'icon_image_2' => $this->filePath('icons/icon-15.png'),
                    ],
                ],
                [
                    'name' => 'faqs',
                    'attributes' => [
                        'style' => '4',
                        'title' => 'Got questions? <br> We\'ve got answers',
                        'subtitle' => 'Frequently Asked questions',
                        'description' => 'Quick answers to questions you may have. Can\'t find what you\'re looking for? Get in touch with us. ',
                        'image' => $this->filePath('general/faqs-4-1.png'),
                        'image_1' => $this->filePath('general/faqs-4-2.png'),
                        'category_ids' => '1,2,3',
                        'limit' => '5',
                        'primary_action_label' => 'Get in touch',
                        'primary_action_url' => '/contact',
                        'primary_action_icon' => 'ti ti-arrow-up-right',
                        'secondary_action_label' => 'Help Center',
                        'secondary_action_url' => '/contact',
                    ],
                ],
                [
                    'name' => 'testimonials',
                    'attributes' => [
                        'style' => '4',
                        'title' => 'What <b> People Say </b> About <br> <b>Our Company</b>',
                        'subtitle' => 'TESTIMONIALS',
                        'description' => 'Access top-tier group mentoring plans and exclusive professional <br> benefits for your team. 🔥',
                        'testimonial_ids' => '1,2,3,4,5',
                        'background_image' => $this->filePath('backgrounds/team.png'),
                    ],
                ],
                [
                    'name' => 'blog-posts',
                    'attributes' => [
                        'style' => '5',
                        'title' => 'Our Latest Articles',
                        'subtitle' => 'FROM BLOG',
                        'description' => 'Explore the insights and trends shaping our industry',
                        'paginate' => '4',
                        'category_ids' => '2,4,7',
                        'action_label' => 'See all articles',
                        'action_url' => '/blog',
                    ],
                ],
                [
                    'name' => 'contact-form',
                    'attributes' => [
                        'style' => 1,
                        'title' => 'Thinking about a project? Get in touch with us.',
                        'subtitle' => 'Contact Us',
                        'description' => 'Please let us know if you have a question, want to leave \n a comment, or would like further information about \n Infinia Systems.',
                        'background_image' => $this->filePath('backgrounds/contact.png'),
                        'form_title' => 'Get in touch',
                        'form_description' => 'Do you want to know more or contact our sales department?',
                        'display_fields' => 'phone,email,subject,address',
                        'mandatory_fields' => 'email',
                        'quantity' => 4,
                        'title_1' => 'Visit the Knowledge Base',
                        'description_1' => 'Browse customer support articles and step-by-step instructions for specific features.',
                        'icon_1' => 'ti ti-search',
                        'title_2' => 'Watch Product Videos',
                        'description_2' => 'Watch our video tutorials for visual walkthroughes on how to use our features.',
                        'icon_2' => 'ti ti-video',
                        'title_3' => 'Visit the Knowledge Base',
                        'description_3' => 'Let us talk about how we can help your enterprise.',
                        'icon_3' => 'ti ti-headphones',
                    ],
                ],
            ]),
        ]);
    }
}
