<?php

namespace Database\Seeders\Themes\Home2;

use Botble\Page\Models\Page;

class PageSeeder extends \Database\Seeders\Themes\Main\PageSeeder
{
    public function run(): void
    {
        parent::run();

        $homepage = Page::query()->where('name', 'Homepage')->firstOrFail();

        $homepage->update([
           'content' => $this->generateShortcodeContent([
               [
                   'name' => 'hero-banner',
                   'attributes' => [
                       'style' => '2',
                       'title' => 'Online Conference Tools <br> <b> High-Quality </b> Video and Audio',
                       'subtitle' => '🚀 Free Lifetime Update',
                       'image' => $this->filePath('general/hero-banner-2.png'),
                       'background_image' => $this->filePath('backgrounds/team.png'),
                       'primary_action_label' => 'Get Started',
                       'primary_action_url' => '/contact',
                       'primary_action_icon' => 'ti ti-arrow-up-right',
                       'secondary_action_label' => 'Contact Us',
                       'secondary_action_url' => '/contact-us',
                       'secondary_action_icon' => 'ti ti-phone-call',
                       'floating_card_title' => 'Features',
                       'floating_card_description' => 'Discover why hundreds of millions <br> people use Infinia to chat and call daily.',
                       'quantity' => '5',
                       'title_1' => 'HD video calling',
                       'title_2' => 'Smart messaging',
                       'title_3' => 'Screen sharing',
                       'title_4' => 'Private conversations',
                       'title_5' => 'Call recording',
                       'display_social_links' => '0,1',
                       'social_links_box_title' => 'Follow us:',
                   ],
               ],
               [
                   'name' => 'partners',
                   'attributes' => [
                       'style' => 4,
                       'title' => 'We always evaluate our skills <br> through our performance',
                       'subtitle' => 'Trusted by great companies',
                       'quantity' => 20,
                       ...collect(['Framer', 'Reddit', 'Netflix', 'Microsoft', 'Discover', 'Lemon Squeezy', 'Paypal', 'Youtube', 'Spotify', 'Google', 'Amazon', 'Apple', 'Facebook', 'Twitter', 'Instagram', 'Slack', 'Tiktok', 'Pinterest', 'Medium', 'Linkedin'])
                           ->mapWithKeys(function ($name, $index) {
                               $index++;

                               $imageName = $index > 8 ? rand(1, 8) : $index;

                               return [
                                   "name_$index" => $name,
                                   "image_$index" => $this->filePath("partners/$imageName.png"),
                                   "url_$index" => 'https://google.com',
                                   "open_in_new_tab_$index" => true,
                               ];
                           })
                           ->all(),
                       'background_color' => '#111827',
                   ],
               ],
               [
                   'name' => 'services',
                   'attributes' => [
                       'style' => '4',
                       'title' => 'Professional <b>UltraHD Video</b> <br> <b>Conferencing</b> Platform',
                       'subtitle' => 'WHAT WE OFFERS',
                       'service_ids' => '1,3,4,6',
                       'primary_action_label' => 'Get Free Quote',
                       'primary_action_icon' => 'ti ti-arrow-up-right',
                       'primary_action_url' => '/contact',
                       'secondary_action_label' => 'How We Work',
                       'secondary_action_url' => '/contact',
                   ],
               ],
               [
                   'name' => 'platforms-featured',
                   'attributes' => [
                       'style' => '1',
                       'title' => 'All that\'s necessary for <b>effective team</b> <br> <b>effort</b>.',
                       'description' => 'Provide your team with top-tier group mentoring programs and exceptional professional benefits.',
                       'image' => $this->filePath('general/platforms-featured-1.png'),
                       'primary_action_label' => 'Explore Now',
                       'primary_action_url' => '/contact',
                       'primary_action_icon' => 'ti ti-arrow-up-right',
                       'quantity' => '5',
                       'title_1' => 'Team Messaging',
                       'url_1' => '/',
                       'title_2' => '4K Video',
                       'url_2' => '/',
                       'title_3' => 'Ultimate Collaboration',
                       'url_3' => '/',
                       'title_4' => 'Unified Communications',
                       'url_4' => '/',
                       'title_5' => 'Advanced Meeting',
                       'url_5' => '/',
                   ],
               ],
               [
                    'name' => 'platforms-featured',
                   'attributes' => [
                       'style' => '2',
                       'title' => 'Experience the <br> <b> cutting-edge </b> <br> capabilities',
                       'description' => 'Provide your team with top-tier group mentoring programs and exceptional professional benefits.',
                       'image' => $this->filePath('general/platforms-featured-2-1.png'),
                       'image_1' => $this->filePath('general/platforms-featured-2-2.png'),
                       'primary_action_label' => 'Explore Now',
                       'primary_action_url' => '/contact',
                       'primary_action_icon' => 'ti ti-arrow-up-right',
                       'bottom_description' => 'Compatible with all operating systems and browsers in the world',
                       'quantity' => '10',
                       'title_1' => 'MacOs',
                       'url_1' => '/',
                       'icon_image_1' => $this->filePath('icons/finder.png'),
                       'title_2' => 'Windows',
                       'url_2' => '/',
                       'icon_image_2' => $this->filePath('icons/window.png'),
                       'title_3' => 'Linux',
                       'url_3' => '/',
                       'icon_image_3' => $this->filePath('icons/linux.png'),
                       'title_4' => 'Android',
                       'url_4' => '/',
                       'icon_image_4' => $this->filePath('icons/android.png'),
                       'title_5' => 'iOS',
                       'url_5' => '/',
                       'icon_image_5' => $this->filePath('icons/apple.png'),
                       'title_6' => 'Firefox',
                       'url_6' => '/',
                       'icon_image_6' => $this->filePath('icons/firefox.png'),
                       'title_7' => 'Chrome',
                       'url_7' => '/',
                       'icon_image_7' => $this->filePath('icons/chrome.png'),
                       'title_8' => 'Safari',
                       'url_8' => '/',
                       'icon_image_8' => $this->filePath('icons/safari.png'),
                       'title_9' => 'Opera',
                       'url_9' => '/',
                       'icon_image_9' => $this->filePath('icons/opera-mini.png'),
                       'title_10' => 'Brave',
                       'url_10' => '/',
                       'icon_image_10' => $this->filePath('icons/brave.png'),
                   ],
               ],
               [
                   'name' => 'testimonials',
                   'attributes' => [
                       'style' => '2',
                       'title' => '<b> +100k users </b> have loved <br> <b> Infinia Conference </b> System',
                       'description' => 'Provide your team with top-tier group mentoring programs and exceptional professional benefits.',
                       'testimonial_ids' => '1,2,3,4,5,6',
                       'primary_action_label' => 'View More Testimonials',
                       'primary_action_icon' => 'ti ti-arrow-up-right',
                       'primary_action_url' => '/about-us',
                   ],
               ],
               [
                   'name' => 'site-statistics',
                   'attributes' => [
                       'style' => '2',
                       'title' => 'Numbers Speaking for <br> Themselves',
                       'quantity' => '4',
                       'title_1' => 'Users Active / Month',
                       'data_1' => '500',
                       'unit_1' => 'k+',
                       'title_2' => 'New Download / Month',
                       'data_2' => '38',
                       'unit_2' => 'k',
                       'title_3' => 'Operating countries',
                       'data_3' => '150',
                       'title_4' => 'Businesses trust on the worldinfinia',
                       'data_4' => '4000',
                       'background_image' => $this->filePath('shapes/site-statistics-decorate.png'),
                       'background_color' => '#6d4df2',
                   ],
               ],
               [
                   'name' => 'app-downloads',
                   'attributes' => [
                       'title' => 'Manage all <br> from anywhere',
                       'subtitle' => 'Download Mobile App',
                       'description' => '⚡Don\'t miss any contact. Stay connected.',
                       'image' => $this->filePath('general/app-downloads-img.png'),
                       'features' => 'Beautiful and awesome interface | Online collaborative anytime, anywhere. | Real-time updates',
                       'quantity' => '3',
                       'name_1' => 'Apple',
                       'url_1' => 'https://www.apple.com/',
                       'image_1' => $this->filePath('general/apple-store.png'),
                       'name_2' => 'Google Play',
                       'url_2' => 'https://play.google.com/',
                       'image_2' => $this->filePath('general/google-play.png'),
                       'name_3' => 'Microsoft',
                       'url_3' => 'https://www.microsoft.com/',
                       'image_3' => $this->filePath('general/microsoft.png'),
                       'reviews_card_title' => ' Trusted by 1M+ customers',
                       'reviews_card_image' => $this->filePath('general/customer-reviews.png'),
                       'reviews_card_rate' => '4.8/5',
                       'reviews_card_data' => '26',
                       'reviews_card_unit' => 'k Reviews',
                   ],
               ],
               [
                   'name' => 'teams',
                   'attributes' => [
                       'style' => '5',
                       'title' => 'Meet Our Team',
                       'subtitle' => 'OUR TEAM MEMBERS',
                       'description' => 'Meet the talented and passionate team members who drive our company forward every day.',
                       'team_ids' => '1,2,3,4,5,6',
                       'quantity' => '1',
                       'title_1' => '+1 (24) 567 890',
                       'subtitle_1' => 'CONTACT US',
                       'url_1' => 'tel:124567890',
                       'icon_image_1' => $this->filePath('icons/contact.png'),
                   ],
               ],
               [
                   'name' => 'instruction-steps',
                   'attributes' => [
                       'title' => 'We make <b> things easy </b> <br> <b> for </b> your business',
                       'subtitle' => 'WHAT WE OFFERS',
                       'description' => 'Meet the talented and passionate team members who drive our company forward every day.',
                       'image' => $this->filePath('general/instruction-steps-img.png'),
                       'quantity' => '3',
                       'title_1' => 'Choose A Package',
                       'description_1' => 'A business consultant provides expert <br> advice and guidance to businesses on <br> various aspects.',
                       'icon_image_1' => $this->filePath('icons/icon-16.png'),
                       'title_2' => 'Make Secure Payment',
                       'description_2' => 'A business consultant provides expert <br> advice and guidance to businesses on <br> various aspects.',
                       'icon_image_2' => $this->filePath('icons/icon-17.png'),
                       'title_3' => 'Get Instant Access',
                       'description_3' => 'A business consultant provides expert <br> advice and guidance to businesses on <br> various aspects.',
                       'icon_image_3' => $this->filePath('icons/icon-18.png'),
                       'primary_action_label' => 'Join Free for 30 Days',
                       'primary_action_icon' => 'ti ti-arrow-up-right',
                       'primary_action_url' => '/contact',
                       'secondary_action_label' => 'Video Guide',
                       'secondary_action_url' => 'https://www.youtube.com/watch?v=tRxGSHL8bI0',
                       'secondary_action_icon' => 'ti ti-brand-youtube',
                       'background_image' => $this->filePath('backgrounds/team.png'),
                   ],
               ],
               [
                   'name' => 'pricing-plans',
                   'attributes' => [
                       'style' => '2',
                       'title' => 'Pick Your Premium',
                       'subtitle' => 'OUR PLANS',
                       'description' => 'Upgrade to Spotify Premium and take your music journey to the next level. Enjoy uninterrupted music playback, even in offline mode',
                       'features' => 'Get 30 day free trial \n You can cancel anytime \n No any hidden fees pay \n Monthly management',
                       'bottom_title' => 'Trusted by secure payment service',
                       'quantity' => '4',
                       'name_1' => 'PayPal',
                       'url_1' => 'https://www.paypal.com/',
                       'image_1' => $this->filePath('general/paypal.png'),
                       'name_2' => 'Stripe',
                       'url_2' => 'https://www.stripe.com/',
                       'image_2' => $this->filePath('general/stripe.png'),
                       'name_3' => 'Mastercard',
                       'url_3' => 'https://www.mastercard.us/en-us.html',
                       'image_3' => $this->filePath('general/mastercard.png'),
                       'name_4' => 'Skrill',
                       'url_4' => 'https://www.skrill.com/',
                       'image_4' => $this->filePath('general/skrill.png'),
                       'package_ids' => '1,2',
                   ],
               ],
               [
                   'name' => 'faqs',
                   'attributes' => [
                       'style' => '2',
                       'title' => 'Frequently Asked  <br> Questions',
                       'description' => 'Find the answers to all of our most frequently asked questions',
                       'image' => $this->filePath('general/faqs-img-2.png'),
                       'quantity' => '3',
                       'title_1' => 'Live chat support 24/7',
                       'description_1' => 'More than 300 employees are ready to help you',
                       'icon_image_1' => $this->filePath('icons/icon-1.png'),
                       'title_2' => 'Help desk support center',
                       'description_2' => 'Via ticket system. 24/7 available.',
                       'icon_image_2' => $this->filePath('icons/icon-2.png'),
                       'title_3' => 'Book a demo',
                       'description_3' => 'Live support via video call',
                       'icon_image_3' => $this->filePath('icons/icon-15.png'),
                       'category_ids' => '1,2,3',
                       'background_image' => $this->filePath('backgrounds/faqs.png'),
                   ],
               ],
               [
                   'name' => 'blog-posts',
                   'attributes' => [
                        'style' => '3',
                        'title' => 'Our Latest <br> News and <br> Articles',
                        'subtitle' => 'FROM BLOG',
                        'description' => 'Explore the insights and trends shaping our industry. 🔥',
                        'paginate' => '5',
                        'action_label' => 'See all articles',
                        'action_url' => '/blog',
                        'background_image' => $this->filePath('backgrounds/team.png'),
                    ],
               ],
           ]),
        ]);
    }
}
